# The Small‑Business LOTL Hunter's Playbook

**Cyborama, LLC – "Threat Intelligence with Teeth™"**

## 📖 What This Is
A step‑by‑step guide for IT admins to build their own living‑off‑the‑land (LOTL) detection system for networks of 10‑200 endpoints. No enterprise budget required—just PowerShell, basic Python, and Windows built‑in tools.

## 🎯 Who It's For
- Small‑business IT admins tired of expensive security tools
- MSPs looking to add LOTL detection to their service stack  
- Security‑conscious network owners with 10‑200 Windows endpoints
- Anyone who wants to understand LOTL threats instead of buying black‑box solutions

## 🛡️ What You'll Learn to Build

### Phase 1: The Detection Engine (PowerShell)
```powershell
# You'll create scripts that:
1. Scan for encoded PowerShell commands (-enc, IEX, DownloadString)
2. Find suspicious scheduled tasks (created via schtasks/WMI)
3. Detect WMI event consumers used for persistence
4. Spot LOLBAS abuse (certutil, bitsadmin, mshta, rundll32)
5. Check registry Run‑keys for unusual entries
```

### Phase 2: The Dashboard (Python/Flask)
```python
# You'll build a web dashboard that:
1. Parses scan results into a SQLite database
2. Shows findings by risk level (High/Medium/Low)
3. Tracks hosts and their security posture
4. Provides API endpoints for automation
5. Generates HTML reports for management
```

### Phase 3: Deployment & Automation
```yaml
# You'll set up:
1. Scheduled daily scans via Windows Task Scheduler
2. Central collection point for multiple endpoints
3. Email alerts for critical findings
4. Basic threat‑hunting workflows
5. Maintenance and updating procedures
```

## 📦 What's in the Package

### 1. **Core Detection Scripts** (PowerShell)
- `LOT-Squatch.ps1` – Main detection engine
- Rule‑based detection (Sigma‑compatible YAML)
- HTML report generation
- Sample malicious patterns for testing

### 2. **Dashboard Code** (Python)
- Flask web application with SQLite backend
- HTML templates for professional reporting
- API endpoints for automation
- Host management and statistics

### 3. **Deployment Guides**
- Step‑by‑step installation for Windows endpoints
- Scheduling with Task Scheduler
- Central collection server setup
- Email alert configuration

### 4. **Operational Playbooks**
- How to investigate each type of finding
- Remediation steps for common LOTL techniques
- Daily, weekly, and monthly review checklists
- Integration with existing security tools

### 5. **Sample Data & Testing**
- Safe test patterns to validate your setup
- Sample reports showing what to expect
- False‑positive tuning guidance
- Performance optimization tips

## 🚀 Getting Started (30‑Minute Setup)

### Step 1: Deploy the Scanner
```powershell
# Copy LOT-Squatch.ps1 to your endpoints
# Schedule daily scan
schtasks /create /tn "LOTL Scan" /tr "powershell -ExecutionPolicy Bypass -File C:\Security\LOT-Squatch.ps1" /sc daily /st 02:00
```

### Step 2: Set Up the Dashboard
```bash
# Install Python dependencies
pip install flask sqlite3 beautifulsoup4

# Run the dashboard
python lotl-dashboard.py
```

### Step 3: First Scan & Review
```powershell
# Run manually
.\LOT-Squatch.ps1 -OutputPath C:\Scans\

# View results
Start-Process C:\Scans\lotl-report-$(Get-Date -Format yyyy-MM-dd).html
```

## 🔧 What Makes This Different

| Feature | Enterprise Tools | Our Playbook |
|---------|-----------------|--------------|
| **Cost** | $1,000+/year per endpoint | One‑time $19.99 (unlimited endpoints) |
| **Complexity** | Requires security team | Built for IT admins |
| **Maintenance** | Vendor‑locked updates | You control the code |
| **Understanding** | Black‑box alerts | You learn how detection works |
| **Customization** | Limited | Full access to modify rules |

## 🎓 Learning Outcomes
By the end of this playbook, you'll be able to:
1. **Explain** how LOTL attacks work on Windows systems
2. **Detect** common LOTL techniques using built‑in tools
3. **Build** a centralized dashboard for your network
4. **Investigate** findings and determine true vs. false positives
5. **Automate** daily scanning and alerting
6. **Adapt** detection rules for your specific environment

## 📈 Business Value
- **Cost savings:** Replace $10k+ enterprise tools
- **Skill development:** Your team becomes LOTL‑capable
- **Control:** No vendor lock‑in, no subscription fees
- **Transparency:** Full visibility into how detection works
- **Scalability:** Works for 10 endpoints or 200

## 🔐 Security First
- **No agents:** Uses existing Windows capabilities
- **Local‑only:** Scans don't send data outside your network
- **Transparent code:** Review everything before deployment
- **Safe testing:** Includes non‑destructive validation patterns

## 💼 Professional Packaging
This isn't just a collection of scripts—it's a **complete operational guide** with:
- Ready‑to‑use code
- Deployment checklists
- Investigation workflows
- Management reporting templates
- Ongoing maintenance procedures

## 🆘 Support Included
- 90‑day email support for setup questions
- Access to rule‑updates via GitHub
- Community forum for sharing custom rules
- Priority access to future OT security playbooks

## 🎯 Perfect For
- **MSPs** adding LOTL detection to client offerings
- **Small businesses** needing enterprise‑grade security on a budget
- **IT teams** wanting to understand threats instead of buying tools
- **Security professionals** building detection capabilities from scratch

---

## 📋 Purchase Includes

✅ **LOT‑Squatch PowerShell Scanner** (500+ lines, commented)  
✅ **Flask Dashboard** with SQLite backend (complete web UI)  
✅ **Deployment Guide** (step‑by‑step with screenshots)  
✅ **Operational Playbook** (daily/weekly/monthly workflows)  
✅ **Sample Data & Testing Suite** (safe validation patterns)  
✅ **Rule‑Update Mechanism** (GitHub‑based Sigma rules)  
✅ **90‑Day Email Support** (setup and configuration help)  
✅ **Unlimited Endpoint License** (one admin, all your devices)  

**Price:** $19.99 one‑time (per‑admin license)

**Format:** Digital download (PDF + ZIP with all code)

**Updates:** Free rule‑updates via GitHub, major version updates at 50% discount

---

## 📞 Before You Buy

**This is right for you if:**
- You have Windows endpoints to protect
- You're comfortable with basic PowerShell/Python
- You want to understand threats, not just get alerts
- You prefer one‑time cost over subscriptions

**Consider alternatives if:**
- You need real‑time (not daily) monitoring
- You have a dedicated security team already
- You prefer fully‑managed SaaS solutions
- You need Linux/macOS support (Windows‑only initially)

---

**Cyborama, LLC – "Threat Intelligence with Teeth™"**  
*OT Security Solutions for Industrial Environments*