# Deployment Checklist

## 📋 Complete Deployment Roadmap

### Phase 1: Preparation (Day 1)

#### Environment Assessment
- [ ] **Inventory endpoints** (count Windows systems)
- [ ] **Identify test systems** (non-production)
- [ ] **Check PowerShell versions** (5.1+ required)
- [ ] **Review execution policies** (may need adjustment)
- [ ] **Allocate storage** for reports (100MB+ recommended)
- [ ] **Schedule maintenance window** for initial scans

#### Team Preparation
- [ ] **Identify stakeholders** (IT, security, management)
- [ ] **Assign roles** (who runs scans, who investigates)
- [ ] **Schedule training** on LOTL threats
- [ ] **Establish communication plan** for findings
- [ ] **Set up support channels** (email, chat)

### Phase 2: Testing (Days 2-3)

#### Single Endpoint Test
- [ ] **Copy scripts** to test system
- [ ] **Run Quick-Start.ps1**
- [ ] **Review HTML report**
- [ ] **Document findings**
- [ ] **Adjust detection rules** if needed
- [ ] **Validate** no system impact

#### Multi-Endpoint Pilot
- [ ] **Select 3-5 representative systems**
- [ ] **Deploy scripts** via Group Policy or manual copy
- [ ] **Schedule daily scans** via Task Scheduler
- [ ] **Monitor for 48 hours**
- [ ] **Collect feedback** from pilot team
- [ ] **Tune detection** based on findings

### Phase 3: Dashboard Setup (Days 4-5)

#### Server Preparation
- [ ] **Choose central server** (Windows/Linux)
- [ ] **Install Python 3.8+**
- [ ] **Install dependencies** (`pip install -r requirements.txt`)
- [ ] **Configure firewall** (port 5000 or custom)
- [ ] **Set up database directory** (write permissions)

#### Dashboard Configuration
- [ ] **Copy dashboard files** to server
- [ ] **Test dashboard startup** (`python app.py`)
- [ ] **Configure as service** (optional, for 24/7)
- [ ] **Set up SSL certificate** (recommended for production)
- [ ] **Create admin account** if implementing auth
- [ ] **Test report upload** functionality

### Phase 4: Full Deployment (Week 2)

#### Endpoint Rollout
- [ ] **Create deployment package** (scripts + config)
- [ ] **Choose deployment method:**
  - [ ] **Group Policy** (for domain environments)
  - [ ] **SCCM/Intune** (for enterprise)
  - [ ] **Manual copy** (for small networks)
  - [ ] **Scripted deployment** (PowerShell remoting)
- [ ] **Deploy in batches** (10-20 systems per day)
- [ ] **Verify deployment** (check task schedules)
- [ ] **Monitor initial scans**

#### Central Collection Setup
- [ ] **Configure endpoints** to upload reports
- [ ] **Set up network share** or HTTP upload
- [ ] **Test data flow** (report → dashboard)
- [ ] **Configure retention policy** (30-90 days)
- [ ] **Set up backups** of database

### Phase 5: Automation & Integration (Week 3)

#### Alerting Configuration
- [ ] **Set up email alerts** for high-risk findings
- [ ] **Configure SMS alerts** for critical items (optional)
- [ ] **Integrate with ticketing system** (Jira, ServiceNow)
- [ ] **Set up Slack/Teams notifications**
- [ ] **Create escalation procedures**

#### Process Integration
- [ ] **Add to daily checklist** for IT team
- [ ] **Integrate with change management**
- [ ] **Link to asset inventory**
- [ ] **Connect to vulnerability management**
- [ ] **Document in runbooks**

### Phase 6: Operationalization (Week 4+)

#### Team Training
- [ ] **LOTL threat training** (what to look for)
- [ ] **Investigation procedures** (step-by-step)
- [ ] **False positive management**
- [ ] **Dashboard usage** (how to review findings)
- [ ] **Reporting to management**

#### Process Documentation
- [ ] **Daily procedures** (checking dashboard)
- [ ] **Weekly reviews** (trend analysis)
- [ ] **Monthly reporting** (metrics to management)
- [ ] **Quarterly tuning** (rule updates)
- [ ] **Incident response** integration

## 🔧 Technical Checklists

### PowerShell Script Configuration
```
[ ] Execution policy set (RemoteSigned)
[ ] Scripts signed (optional for security)
[ ] Logging configured (path, retention)
[ ] Error handling tested
[ ] Performance optimized (timeouts, limits)
```

### Task Scheduler Configuration
```
[ ] Task created with proper triggers
[ ] Runs with SYSTEM or admin account
[ ] Set to run whether logged in or not
[ ] Configured to restart on failure
[ ] Logging enabled for task execution
```

### Dashboard Server Requirements
```
[ ] Python 3.8+ installed
[ ] Port 5000 (or custom) open
[ ] Disk space for database (1GB+)
[ ] Regular backups scheduled
[ ] Monitoring configured
```

### Network Considerations
```
[ ] Firewall rules for uploads
[ ] Bandwidth for report transfers
[ ] DNS resolution for server
[ ] Certificate trust (if using SSL)
[ ] Proxy configuration if needed
```

## 🚨 Risk Mitigation

### Deployment Risks
| Risk | Mitigation |
|------|------------|
| **System performance impact** | Schedule scans during off-hours |
| **False positives overwhelming team** | Start with conservative rules, tune gradually |
| **Script conflicts with existing tools** | Test in pilot first, monitor closely |
| **Security concerns about scripts** | Review code, sign scripts, whitelist paths |
| **Team resistance to new process** | Training, clear benefits, management support |

### Operational Risks
| Risk | Mitigation |
|------|------------|
| **Alert fatigue** | Tune rules, prioritize alerts, use thresholds |
| **Missed findings** | Regular rule updates, peer reviews |
| **Dashboard downtime** | Monitor service, set up alerts, have backup |
| **Data loss** | Regular backups, retention policy |
| **Skill gap** | Training, documentation, external support |

## 📊 Success Metrics

### Deployment Metrics
- [ ] **100% endpoint coverage** (target vs actual)
- [ ] **Zero critical incidents** during deployment
- [ ] **< 1 hour** average investigation time
- [ ] **< 5% false positive rate** after tuning
- [ ] **100% team training completion**

### Operational Metrics
- [ ] **Daily scan completion rate** (> 95%)
- [ ] **Time to detect** LOTL activity
- [ ] **Time to respond** to high-risk findings
- [ ] **Dashboard availability** (> 99%)
- [ ] **Team satisfaction** with tool

## 🔄 Continuous Improvement

### Monthly Activities
- [ ] **Review detection rules** (update from GitHub)
- [ ] **Analyze false positives** (tune rules)
- [ ] **Check for new LOLBAS techniques** (update detection)
- [ ] **Review team performance** (training needs)
- [ ] **Update documentation** (process changes)

### Quarterly Activities
- [ ] **Full environment reassessment** (new systems?)
- [ ] **Tool evaluation** (still meeting needs?)
- [ ] **Team skill assessment** (training gaps?)
- [ ] **Management review** (value demonstrated?)
- [ ] **Roadmap planning** (next features?)

### Annual Activities
- [ ] **Complete review** of all detection rules
- [ ] **Business case review** (ROI calculation)
- [ ] **Team certification** (if available)
- [ ] **Vendor evaluation** (alternative tools)
- [ ] **Strategic planning** (integration roadmap)

## 🆘 Support & Maintenance

### Routine Maintenance
```
Daily: Check dashboard, review high-risk findings
Weekly: Review all findings, tune rules, backup database
Monthly: Update rules, review metrics, team training
Quarterly: Full system review, update documentation
```

### Support Contacts
- **Technical support:** support@cyborama.com
- **Community:** GitHub discussions
- **Updates:** https://github.com/cyborama/lotl-hunter
- **Documentation:** Included guides + online resources

### Escalation Path
1. **First line:** Internal IT team (using provided guides)
2. **Second line:** Cyborama email support
3. **Third line:** Community + expert consultation
4. **Emergency:** Direct contact for critical issues

---

**Remember:** Deployment is not a one-time event. It's the beginning of an ongoing security improvement process.

**Cyborama, LLC – "Threat Intelligence with Teeth™"**