# Getting Started with LOTL Hunter

## 🎯 Quick Start (15 Minutes)

### 1. Download & Review
```bash
# Extract the package
Expand-Archive LOTL_Hunter_Playbook.zip -DestinationPath C:\Security\LOTL
cd C:\Security\LOTL\Detection_Engine
```

### 2. First Scan
```powershell
# Run quick scan (non-destructive)
.\Quick-Start.ps1

# Or run full detection
.\LOT-Squatch.ps1 -FullScan
```

### 3. Review Results
- Open the generated HTML report
- Check high-risk findings first
- Refer to the Investigation Playbook for guidance

## 🔧 Prerequisites

### Minimum Requirements
- **Windows 10/11** or **Windows Server 2016+**
- **PowerShell 5.1** or later
- **Administrative privileges** (for full detection)
- **Python 3.8+** (optional, for dashboard)

### Recommended Setup
- **Test environment** first (non-production)
- **Backup** of critical systems
- **Documentation** of existing scheduled tasks/scripts
- **2-4 GB RAM** for scanning multiple endpoints

## 📋 Initial Deployment Checklist

### Phase 1: Single Endpoint Testing
- [ ] **Download** package to test system
- [ ] **Review** scripts for your environment
- [ ] **Run** Quick-Start.ps1
- [ ] **Analyze** findings
- [ ] **Adjust** detection rules if needed
- [ ] **Document** baseline findings

### Phase 2: Pilot Deployment
- [ ] **Select** 3-5 representative endpoints
- [ ] **Deploy** detection scripts
- [ ] **Schedule** daily scans
- [ ] **Monitor** for false positives
- [ ] **Tune** detection rules

### Phase 3: Full Deployment
- [ ] **Roll out** to all endpoints
- [ ] **Set up** central dashboard
- [ ] **Configure** email alerts
- [ ] **Train** team on investigation
- [ ] **Establish** review process

## 🚨 Important Safety Notes

### Before You Scan
1. **Back up** critical systems
2. **Test** on non-production first
3. **Review** PowerShell execution policy
4. **Check** disk space for logs (100MB+ recommended)
5. **Notify** users if scanning workstations

### During Scanning
- **Avoid** peak business hours
- **Monitor** system performance
- **Check** for application compatibility
- **Document** any issues

### After Scanning
- **Review** findings promptly
- **Investigate** within 24 hours
- **Update** detection rules as needed
- **Schedule** regular maintenance

## 🔍 Understanding Your First Scan

### Expected Output
```
📊 Scan Results:
   High risk:   0
   Medium risk: 2  
   Low risk:    5
   Total:       7
```

### What Each Finding Means

| Risk Level | Action Required | Timeframe |
|------------|----------------|-----------|
| **High** | Immediate investigation | Within 2 hours |
| **Medium** | Investigate soon | Within 24 hours |
| **Low** | Monitor & review | Weekly review |
| **Info** | Log for reference | Monthly review |

### Common Initial Findings
1. **Legitimate administrative scripts** (false positive)
2. **Software installation artifacts** (usually safe)
3. **Backup/maintenance tasks** (expected)
4. **Security tool operations** (authorized)

## 📈 Next Steps After First Scan

### Day 1-2: Initial Review
1. **Categorize** findings by risk
2. **Investigate** high-risk items first
3. **Document** false positives
4. **Update** detection rules

### Week 1: Baseline Establishment
1. **Run** daily scans
2. **Monitor** for new findings
3. **Establish** normal patterns
4. **Tune** detection sensitivity

### Month 1: Operationalization
1. **Deploy** to all endpoints
2. **Set up** central dashboard
3. **Train** team members
4. **Integrate** with existing tools

## 🆘 Getting Help

### Common Issues & Solutions

**Issue:** "Script won't run"
- **Solution:** Run PowerShell as Administrator
- **Solution:** Set execution policy: `Set-ExecutionPolicy RemoteSigned`

**Issue:** "No findings reported"
- **Solution:** Check PowerShell version (needs 5.1+)
- **Solution:** Run with `-FullScan` parameter

**Issue:** "Too many false positives"
- **Solution:** Review and adjust detection rules
- **Solution:** Whitelist legitimate activities

**Issue:** "Dashboard won't start"
- **Solution:** Install Python dependencies
- **Solution:** Check port 5000 isn't in use

### Support Channels
- **Email:** support@cyborama.com
- **Documentation:** Included guides
- **Community:** GitHub discussions
- **Updates:** Regular rule updates

## ✅ Success Metrics

### Short-term (Week 1)
- [ ] First scan completed successfully
- [ ] High-risk findings investigated
- [ ] False positives documented
- [ ] Daily scans scheduled

### Medium-term (Month 1)
- [ ] All endpoints scanning daily
- [ ] Dashboard operational
- [ ] Team trained on investigation
- [ ] Baseline established

### Long-term (Quarter 1)
- [ ] Integration with existing tools
- [ ] Automated alerting configured
- [ ] Regular review process
- [ ] Detection rules customized

---

**Remember:** The goal is **understanding**, not just detection. Each finding teaches you about your environment and the threats it faces.

**Cyborama, LLC – "Threat Intelligence with Teeth™"**